<?php

namespace App\Models\Quizes;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Quiz extends Model 
{

    protected $table = 'quizes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function getInstitution()
    {
        return $this->belongsTo('Institution');
    }

    public function getUser()
    {
        return $this->belongsTo('User');
    }

    public function getChallengeElements()
    {
        return $this->hasMany('ChallengeElement');
    }

    public function getAccreditation()
    {
        return $this->hasOne('Accreditation');
    }

    public function getKeywords()
    {
        return $this->belongsToMany('Keyword', 'quiz_keyword');
    }

    public function getAttendances()
    {
        return $this->hasMany('Attendance');
    }

    public function getEpisodeType()
    {
        return $this->belongsTo('EpisodeType');
    }

    public function getInvolvement()
    {
        return $this->belongsTo('InvolvementsTypes');
    }

}